//
//  GSExportSettingsViewController.h
//  GlyphsCore
//
//  Created by Georg Seifert on 01.06.21.
//  Copyright © 2021 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <GlyphsCore/GlyphsFileFormatProtocol.h>
NS_ASSUME_NONNULL_BEGIN

@interface GSExportSettingsViewController : NSViewController <GlyphsProgressDelegate>

@property (strong) NSObject<GlyphsProgressProtocol> *progressController;
@property (weak) IBOutlet NSPopUpButton *recentExportPathsButton;

@property (weak) GSFont *font;

- (IBAction)openDoc:(id)sender;

- (NSString *)exportPathKey;

- (NSString *)exportRecentExportPathsKey;

- (void)showProgress;

- (void)hideProgress;

- (void)setupRecentExportPathsButton;
@end

NS_ASSUME_NONNULL_END
